/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.block.PortableGridBlock;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGrid;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGridDiskState;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.render.model.DelegateBakedModel;
import com.refinedmods.refinedstorage.render.model.PortableGridItemBakedModel;
import com.refinedmods.refinedstorage.render.model.QuadTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PortableGridBakedModel
extends DelegateBakedModel {
    private final BakedModel baseConnected;
    private final BakedModel baseDisconnected;
    private final BakedModel disk;
    private final BakedModel diskNearCapacity;
    private final BakedModel diskFull;
    private final BakedModel diskDisconnected;
    private final CustomItemOverrideList itemOverrideList = new CustomItemOverrideList();
    private final LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull CacheKey key) {
            Direction direction = (Direction)key.state.m_61143_((Property)((PortableGridBlock)((Object)RSBlocks.PORTABLE_GRID.get())).getDirection().getProperty());
            boolean active = (Boolean)key.state.m_61143_((Property)PortableGridBlock.ACTIVE);
            PortableGridDiskState diskState = (PortableGridDiskState)((Object)key.state.m_61143_(PortableGridBlock.DISK_STATE));
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(QuadTransformer.getTransformedQuads(active ? PortableGridBakedModel.this.baseConnected : PortableGridBakedModel.this.baseDisconnected, direction, null, key.state, key.random, key.side));
            BakedModel diskModel = PortableGridBakedModel.this.getDiskModel(diskState);
            if (diskModel != null) {
                quads.addAll(QuadTransformer.getTransformedQuads(diskModel, direction, null, key.state, key.random, key.side));
            }
            return quads;
        }
    });

    public PortableGridBakedModel(BakedModel baseConnected, BakedModel baseDisconnected, BakedModel disk, BakedModel diskNearCapacity, BakedModel diskFull, BakedModel diskDisconnected) {
        super(baseConnected);
        this.baseConnected = baseConnected;
        this.baseDisconnected = baseDisconnected;
        this.disk = disk;
        this.diskNearCapacity = diskNearCapacity;
        this.diskFull = diskFull;
        this.diskDisconnected = diskDisconnected;
    }

    @Nullable
    private BakedModel getDiskModel(PortableGridDiskState state) {
        switch (state) {
            case NORMAL: {
                return this.disk;
            }
            case NEAR_CAPACITY: {
                return this.diskNearCapacity;
            }
            case FULL: {
                return this.diskFull;
            }
            case DISCONNECTED: {
                return this.diskDisconnected;
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public ItemOverrides m_7343_() {
        return this.itemOverrideList;
    }

    @Override
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (state != null) {
            return (List)this.cache.getUnchecked((Object)new CacheKey(state, side, rand));
        }
        return super.m_6840_(state, side, rand);
    }

    private class CustomItemOverrideList
    extends ItemOverrides {
        private CustomItemOverrideList() {
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p) {
            PortableGrid portableGrid = new PortableGrid(null, stack, new PlayerSlot(-1));
            if (portableGrid.isGridActive()) {
                return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseConnected, PortableGridBakedModel.this.getDiskModel(portableGrid.getDiskState()));
            }
            return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseDisconnected, PortableGridBakedModel.this.getDiskModel(portableGrid.getDiskState()));
        }
    }

    private static class CacheKey {
        private final BlockState state;
        private final Direction side;
        private final Random random;

        public CacheKey(BlockState state, Direction side, Random random) {
            this.state = state;
            this.side = side;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.state.equals(cacheKey.state) && this.side == cacheKey.side && this.random.equals(cacheKey.random);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.side, this.random);
        }
    }
}

